package demo.frame;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import demo.common.*;
import demo.module.*;
import netsdk.callback.SUBSCRIBE_CALLBACK;
import netsdk.callback.impl.SUBSCRIBE_CALLBACK_IMPL;
import netsdk.lib.CommonFunctions;
import netsdk.lib.DeviceSdk;
import netsdk.lib.ErrorCodeAndConst;
import netsdk.lib.ToolKits;
import netsdk.struct.NET_DVR_SUBSCRIBE_REPLY;
import netsdk.struct.NET_SDK_IVE_FACE_MATCH_T;
import netsdk.struct.NET_SDK_IVE_VEHICE_HEAD_INFO;
import netsdk.struct.NET_SDK_IVE_VEHICE_ITEM_INFO;


class VehicleRecognizeFrame extends JFrame{
	// 全景图
	private static BufferedImage globalBufferedImage = null;	
	// 车牌图
	private static BufferedImage vehicleBufferedImage = null;
	public static SUBSCRIBE_CALLBACK AlarmCB;
	private String m_serverAddressVFD;//
	private static final long serialVersionUID = 1L;
	
	private Vector<String> chnlist = new Vector<String>(); 
	private boolean isRealplay = false;
	private static boolean isAttach = false;
	// 预览句柄
	public static NativeLong m_hPlayHandle = new NativeLong(0);
	
	// 获取界面窗口
	private static JFrame frame = new JFrame();   
	
	public VehicleRecognizeFrame() {
	    setTitle(Res.string().getRealplay());
	    setLayout(new BorderLayout());
	    pack();
	    setSize(800, 560);
	    setResizable(false);
	    setLocationRelativeTo(null);
		LoginModule.init();   // 打开工程，初始化
		
    	try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception e) {
        	e.printStackTrace();
        } 
	 
	    loginPanel = new LoginPanel();	    
	    add(loginPanel, BorderLayout.NORTH);
	    
	    vehiclePanel = new VehicleRecognitionEventPanel();
	    add(vehiclePanel, BorderLayout.CENTER);

	    //operatePanel = new JPanel();
	    //add(operatePanel, BorderLayout.CENTER);
	    //operatePanel.setLayout(new FlowLayout());
	    
	    
	    //faceDataBaseBtn = new JButton(Res.string().getGroupOperate());
	    //operatePanel.add(faceDataBaseBtn);
	    
//	    Dimension dim = new Dimension();
//		dim.width = 120;
//		dim.height = 20;
//		faceDataBaseBtn.setPreferredSize(dim);
//		faceDataBaseBtn.setEnabled(false);
		
		

	    
	    loginPanel.addLoginBtnActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {	   	    
				if(loginPanel.checkLoginText()) {
					if(login()) {
						frame = ToolKits.getFrame(e);
						frame.setTitle(Res.string().getVehicleRecognition() + " : " + Res.string().getOnline());
					}
				}
			}
		});
	    
	    loginPanel.addLogoutBtnActionListener(new ActionListener() {		
			@Override
			public void actionPerformed(ActionEvent e) {
				frame.setTitle(Res.string().getVehicleRecognition());
				logout();	
			}
		});
        
	    addWindowListener(new WindowAdapter() {
	    	public void windowClosing(WindowEvent e) {
	    		LoginModule.logout();
	    		LoginModule.cleanup();   // 关闭工程，释放资源
	    		dispose();	
	    		
	    		SwingUtilities.invokeLater(new Runnable() {
	    			public void run() {
	    				FunctionList demo = new FunctionList();
	    				demo.setVisible(true);
	    			}
	    		});
	    	}
	    });
	}
		
	
	// 登录
	public boolean login() {
		if(LoginModule.login(loginPanel.ipTextArea.getText(), 
						Integer.parseInt(loginPanel.portTextArea.getText()), 
						loginPanel.nameTextArea.getText(), 
						new String(loginPanel.passwordTextArea.getPassword()))) {
	
			loginPanel.setButtonEnable(true);
						
			setEnable(true);
			for(int i = 1; i < LoginModule.m_stDeviceInfo.videoInputNum + 1; i++) {
				chnlist.add(Res.string().getChannel() + " " + String.valueOf(i));
				
			}
			// 登陆成功，将通道添加到控件
			chnComboBox.setModel(new DefaultComboBoxModel(chnlist));	
			
		} else {
			JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), JOptionPane.ERROR_MESSAGE);
			return false;
		}
		return true;
	}
	
	// 登出
	public void logout() {

		RealPlayModule.stopRealPlay(m_hPlayHandle);
		LoginModule.logout();

		loginPanel.setButtonEnable(false);
		setEnable(false);
		realplayWindowPanel.repaint();   	
		
		isRealplay = false;
		realplayBtn.setText(Res.string().getStartRealPlay());
				
		isAttach = false;
		
		attachBtn.setText(Res.string().getAttach());
		globalPicLabel.setText(Res.string().getGlobalPicture());

		globalPicShowPanel.setOpaque(true); 
		globalPicShowPanel.repaint();

		vehiclePicShowPanel.setOpaque(true); 
		vehiclePicShowPanel.repaint();
	

        plateField.setText("");
	

		
		for(int i = 0; i < LoginModule.m_stDeviceInfo.videoInputNum + 1; i++) {
			chnlist.clear();
		}
		
		chnComboBox.setModel(new DefaultComboBoxModel());	
		
//		groupId = 0;	
//		globalBufferedImage = null;
//		personBufferedImage = null;
//		candidateBufferedImage = null;	
		
	}
	private void setEnable(boolean bln) {
		
		chnComboBox.setEnabled(bln);
		realplayBtn.setEnabled(bln);
		attachBtn.setEnabled(bln);
		callBackBtn.setEnabled(bln);

	}
	/*
	 * 预览界面通道、码流设置  以及抓图面板
	 */
	private VehicleRecognitionEventPanel vehiclePanel;
	
	/*
	 * 登录
	 */
	private LoginPanel loginPanel;	

	private JPanel operatePanel;;   // 通道、预览、订阅		

	
	private JLabel chnlabel;
	private JComboBox chnComboBox;
	private JButton realplayBtn;
	private JButton attachBtn;
    private JButton callBackBtn;

    private Panel realplayWindowPanel;
	private static PaintPanel globalPicShowPanel;
	private static PaintPanel vehiclePicShowPanel;
	//private static PaintPanel candidatePicShowPanel;
    
	private static JLabel globalPicLabel;
	
    /*
     * 车牌信息
     */
	private static JTextField plateField;
//	private static JTextField lDirect;
	


    
	public class VehicleRecognitionEventPanel extends JPanel{
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
		public VehicleRecognitionEventPanel() {
			BorderEx.set(this, "", 2);
			setLayout(new BorderLayout());
			
			JPanel operatePanel = new JPanel();   // 通道、预览、订阅		
			JPanel panel = new JPanel();	

			add(operatePanel, BorderLayout.NORTH);
			add(panel, BorderLayout.CENTER);
			
			/*
			 * 操作面板：通道、预览、订阅按钮
			 */
			chnlabel = new JLabel(Res.string().getChannel());
			chnComboBox = new JComboBox(); 
			
			realplayBtn = new JButton(Res.string().getStartRealPlay());
			attachBtn = new JButton(Res.string().getAttach());	
			callBackBtn = new JButton(Res.string().getSubscribe());

			
			operatePanel.setLayout(new FlowLayout());
			operatePanel.add(chnlabel);
			operatePanel.add(chnComboBox);
			operatePanel.add(realplayBtn);
			operatePanel.add(attachBtn);
			operatePanel.add(callBackBtn);

			
			Dimension dim = new Dimension();
			dim.width = 120;
			dim.height = 20;
			
			chnComboBox.setPreferredSize(new Dimension(80, 20));
			attachBtn.setPreferredSize(dim);
			realplayBtn.setPreferredSize(dim);
			callBackBtn.setPreferredSize(dim);

			
			chnComboBox.setEnabled(false);
			realplayBtn.setEnabled(false);
			attachBtn.setEnabled(false);
			callBackBtn.setEnabled(false);

			
			/*
			 * 预览、图片面板
			 */
			JPanel realplayPanel = new JPanel();
			JPanel globalPicPanel = new JPanel();
			JPanel personPicPanel = new JPanel();
			JPanel candidatePanel = new JPanel();
			
			realplayPanel.setBorder(new EmptyBorder(0, 5, 5, 5));
			globalPicPanel.setBorder(new EmptyBorder(0, 5, 5, 5));
			personPicPanel.setBorder(new EmptyBorder(0, 5, 5, 5));
			candidatePanel.setBorder(new EmptyBorder(0, 5, 5, 5));
			
			panel.setLayout(new GridLayout(2, 2));
			
			panel.add(realplayPanel);
			panel.add(globalPicPanel);
			panel.add(personPicPanel);
			panel.add(candidatePanel);
			
			/*
			 * 预览面板
			 */
			JLabel realplayLabel = new JLabel(Res.string().getRealplay());
			realplayWindowPanel = new Panel();
			realplayWindowPanel.setBackground(Color.GRAY);
			realplayPanel.setLayout(new BorderLayout());
			realplayPanel.add(realplayLabel, BorderLayout.NORTH);
			realplayPanel.add(realplayWindowPanel, BorderLayout.CENTER);
	
			/*
			 * 全景图面板
			 */
			globalPicLabel = new JLabel(Res.string().getGlobalPicture() + " ------ [" + Res.string().getEventType() + "]");
			globalPicShowPanel = new PaintPanel();
			globalPicPanel.setLayout(new BorderLayout());
			globalPicPanel.add(globalPicLabel, BorderLayout.NORTH);
			globalPicPanel.add(globalPicShowPanel, BorderLayout.CENTER);
			
			/*
			 * 车牌面板
			 */
			JLabel vehiclePiclabel = new JLabel(Res.string().getPlatePicture());
			vehiclePicShowPanel = new PaintPanel();
			JPanel faceDataPanel = new JPanel();
			
			Dimension dimension = new Dimension();
			dimension.width = 200;
			faceDataPanel.setPreferredSize(dimension);
			
			personPicPanel.setLayout(new BorderLayout());
			personPicPanel.add(vehiclePiclabel, BorderLayout.NORTH);
			personPicPanel.add(vehiclePicShowPanel, BorderLayout.CENTER);
			personPicPanel.add(faceDataPanel, BorderLayout.EAST);
			
			// 车牌信息
			JLabel plateLabel = new JLabel(Res.string().getLicensePlate(), JLabel.CENTER);

			
			Dimension dimension1 = new Dimension();
			dimension1.height = 18;
			dimension1.width = 50;
			plateLabel.setPreferredSize(dimension1);

			
			plateField = new JTextField();
//			lDirect = new JTextField();
			
			Dimension dimension2 = new Dimension();
			dimension2.width = 125;
			dimension2.height = 19;

			plateField.setPreferredSize(dimension2);
			
			
			Dimension dimension3 = new Dimension();
			dimension3.width = 125;
			dimension3.height = 19;
//			lDirect.setPreferredSize(dimension3);
			
			plateField.setHorizontalAlignment(JTextField.CENTER);
//			lDirect.setHorizontalAlignment(JTextField.BOTTOM);
			
//			lDirect.setEnabled(false);
			plateField.setEnabled(false);

			plateField.setFont(new Font("黑体", Font.PLAIN, 11));
//			lDirect.setFont(new Font("黑体", Font.PLAIN, 11));
			
			faceDataPanel.setLayout(new FlowLayout());

			faceDataPanel.add(plateLabel);
			faceDataPanel.add(plateField);
//			faceDataPanel.add(lDirect);

			/*
			 * 候选人图面板
			 */
			//JLabel candidateLabel = new JLabel(Res.string().getCandidatePicture());
			//candidatePicShowPanel = new PaintPanel();
			JPanel candidateDataPanel = new JPanel();
			
			Dimension dimension4 = new Dimension();
			dimension4.width = 220;
			candidateDataPanel.setPreferredSize(dimension4);
			
			candidatePanel.setLayout(new BorderLayout());
			//candidatePanel.add(candidateLabel, BorderLayout.NORTH);
			//candidatePanel.add(candidatePicShowPanel, BorderLayout.CENTER);
			candidatePanel.add(candidateDataPanel, BorderLayout.EAST);

		
//			Dimension dimension3 = new Dimension();
//			dimension3.height = 19;
//			dimension3.width = 80;

			

	
		
			candidateDataPanel.setLayout(new FlowLayout());
			
			
			// 预览
			realplayBtn.addActionListener(new ActionListener() {				
				@Override
				public void actionPerformed(ActionEvent arg0) {
					realplay();
				}
			});		
			
			// 订阅
			attachBtn.addActionListener(new ActionListener() {				
				@Override
				public void actionPerformed(ActionEvent arg0) {
					smartSubscrib();
				}
			});
			
			// 注册回调
			callBackBtn.addActionListener(new ActionListener() {			
				@Override
				public void actionPerformed(ActionEvent arg0) {
					subscribCallBack();
				}
			});
			
		}
		
		// 预览
		public void realplay() {
			if(!isRealplay) {
				m_hPlayHandle = RealPlayModule.startRealPlay(chnComboBox.getSelectedIndex(), 
					    		0,
					    		realplayWindowPanel);
				if(m_hPlayHandle.longValue() > 0) {
					realplayWindowPanel.repaint();
					isRealplay = true;
					chnComboBox.setEnabled(false);
					realplayBtn.setText(Res.string().getStopRealPlay());
					
					//FaceRecognitionModule.renderPrivateData(m_hPlayHandle, 1);
				} else {
					JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), JOptionPane.ERROR_MESSAGE);
				}
			} else {
				//FaceRecognitionModule.renderPrivateData(m_hPlayHandle, 0);
				
				RealPlayModule.stopRealPlay(m_hPlayHandle);
				realplayWindowPanel.repaint();
				isRealplay = false;
				chnComboBox.setEnabled(true);
				realplayBtn.setText(Res.string().getStartRealPlay());	
			}	
		}
		// 订阅
		public void smartSubscrib() {
			if(!isAttach) {
				if(LoginModule.m_stDeviceInfo.deviceType == ErrorCodeAndConst.NET_SDK_IPCAMERA) {
					int chn = 0;//IPC通道一般为0
					NET_DVR_SUBSCRIBE_REPLY.ByReference sSmartSubscrib = new NET_DVR_SUBSCRIBE_REPLY.ByReference();
					
					boolean ret = DeviceSdk.INSTANCE.NET_SDK_SmartSubscrib(LoginModule.m_hLoginHandle, 
							ErrorCodeAndConst.NET_IPC_SMART_VIHICLE, chn, sSmartSubscrib);
					if(ret) {
						isAttach = true;
						attachBtn.setText(Res.string().getDetach());						
						m_serverAddressVFD = new String(sSmartSubscrib.serverAddress);
						System.out.println(m_serverAddressVFD);
					}										
				}
				
			} else {
								
				int chn = 0;//IPC通道一般为0
				NET_DVR_SUBSCRIBE_REPLY.ByReference sSmartSubscrib = new NET_DVR_SUBSCRIBE_REPLY.ByReference();
				byte[] sb = m_serverAddressVFD.getBytes();
				Pointer pNativeData = new Memory(sb.length); 
				pNativeData.write(0, sb, 0, sb.length);		
				IntByReference dwResult = new IntByReference();
				boolean ret = DeviceSdk.INSTANCE.NET_SDK_UnSmartSubscrib(LoginModule.m_hLoginHandle, 
						ErrorCodeAndConst.NET_IPC_SMART_VIHICLE, chn, pNativeData, dwResult);
				if(ret) {
					isAttach = false;
					attachBtn.setText(Res.string().getAttach());
					System.out.println("取消订阅报警成功");
					globalPicLabel.setText(Res.string().getGlobalPicture() + " ------ [" + Res.string().getEventType() + "]");	

					globalPicShowPanel.setOpaque(true); 
					globalPicShowPanel.repaint();

					vehiclePicShowPanel.setOpaque(true); 
					vehiclePicShowPanel.repaint();
				
			        plateField.setText("");


				}
				// 释放内存
				long peer = Pointer.nativeValue(pNativeData);
				Native.free(peer);// 手动释放内存
				Pointer.nativeValue(pNativeData, 0);
			}
		}
		
		public void subscribCallBack() {
			AlarmCB = new AnalyzerDataCB();
	        // TODO 设置智能分析事件上报回调
	        DeviceSdk.INSTANCE.NET_SDK_SetSubscribCallBack(AlarmCB, null);
		}
	}
	
	/**
	 * 写成静态主要是防止被回收
	 */
	private static class AnalyzerDataCB implements SUBSCRIBE_CALLBACK {  	
		private AnalyzerDataCB() {}
			
		private static class AnalyzerDataCBHolder {
			private static final AnalyzerDataCB instance = new AnalyzerDataCB();
		}
		
		public static AnalyzerDataCB getInstance() {
			return AnalyzerDataCBHolder.instance;
		}
		
		public void invoke(NativeLong lUserID, int dwCommand, Pointer pBuf, int dwBufLen, Pointer pUser) 
        {
            if (dwBufLen == 0 || pBuf == null) {
                return;
            }   
            DateTimeFormatter format = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
    		DateTime ctime;
    		String folerPath;
    		int restLen = dwBufLen;
    		int offSetLen = 0;
    		int len = 0;
			switch(dwCommand)
            {
				case ErrorCodeAndConst.NET_SDK_N9000_ALARM_TYPE_VEHICE:  ///< 车牌识别事件
				{	
					NET_SDK_IVE_VEHICE_HEAD_INFO vehiceHeadInfo = new NET_SDK_IVE_VEHICE_HEAD_INFO();
		            len = vehiceHeadInfo.size();
		            if(dwBufLen < len)
		            {
		                break;
		            }                
					CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen, vehiceHeadInfo);
					vehiceHeadInfo.read();
					offSetLen += len;//地址偏移
					restLen -= len;//剩余长度
					
					ctime = DateTime.parse(CommonFunctions.stampToDate(vehiceHeadInfo.absoluteTime), format); 
					folerPath = CreatePath(lUserID.intValue(), ctime);
		            
		            int cntVheCle = vehiceHeadInfo.item_cnt;

		            if (cntVheCle > 0)
		            {
		            	System.out.println("车牌识别");
			            for(int i = 0;i< cntVheCle;i++)
			            {
				            NET_SDK_IVE_VEHICE_ITEM_INFO vehicleinfo = new NET_SDK_IVE_VEHICE_ITEM_INFO();
				            CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen, vehicleinfo);
				            vehicleinfo.read();		            
				            offSetLen += vehicleinfo.size();//偏移量
						            					            					
				            if (vehicleinfo.jpeg_len > 0)
				            {
					            if(i == 0)//第1张是源图片
					            {
					            	byte[] data = pBuf.getByteArray(offSetLen, vehicleinfo.jpeg_len);
					            	ByteArrayInputStream byteArrInputGlobal = new ByteArrayInputStream(data);
					            	try {
										globalBufferedImage = ImageIO.read(byteArrInputGlobal);
									} catch (IOException e1) {
										// TODO Auto-generated catch block
										e1.printStackTrace();
									}
					            	File srcPic = new File(folerPath + "\\vehicleSrc.jpg");//
									try {
										srcPic.createNewFile();
										CommonFunctions.writeFileByBytes(folerPath + "\\vehicleSrc.jpg",data,false);//数据写入文件中
									} catch (IOException e) {
										// TODO Auto-generated catch block
										e.printStackTrace();
									}
									offSetLen += vehicleinfo.jpeg_len;//地址偏移
									restLen -= vehicleinfo.jpeg_len;//剩余长度		
					            	                          
					            }
					            else//其他是车牌照片
					            {
				            		byte[] data = pBuf.getByteArray(offSetLen, vehicleinfo.jpeg_len);
				            		ByteArrayInputStream byteArrInputVehicle = new ByteArrayInputStream(data);
				            		try {
				            			vehicleBufferedImage = ImageIO.read(byteArrInputVehicle);
									} catch (IOException e1) {
										// TODO Auto-generated catch block
										e1.printStackTrace();
									}
				            		
					            	File srcPic = new File(folerPath + "\\vehiclePlate.jpg");//
									try {
										srcPic.createNewFile();
										CommonFunctions.writeFileByBytes(folerPath + "\\vehiclePlate.jpg",data,false);//数据写入文件中
									} catch (IOException e) {
										// TODO Auto-generated catch block
										e.printStackTrace();
									}
									offSetLen += vehicleinfo.jpeg_len;//地址偏移
									restLen -= vehicleinfo.jpeg_len;//剩余长度		
					            }
					            // 列表、图片界面显示      
						        EventQueue.invokeLater(new VehicleDetectRunnable(globalBufferedImage,
						        		vehicleBufferedImage,vehicleinfo));
						
				            }
				            
				            if (vehicleinfo.jpeg_vir_len > vehicleinfo.jpeg_len)
				            {
				            	offSetLen += (int)(vehicleinfo.jpeg_vir_len - vehicleinfo.jpeg_len);
				            }
				            vehicleinfo = null;
			            }
		            }
		            
     	            System.gc();
		            break;					
     	            
				} 		           
				default:
					break;
            }
                   
//			return 0;           
        }
	
		private String CreatePath(int userId, DateTime dt)
	    {
	        //String tempPath = "D:\\" + userId + "\\" + dt.getYear() + AddZero(dt.getMonthOfYear()) + AddZero(dt.getDayOfYear());
	        String tempPath = "./VehicleRecognition/";
	        File filePath = new File(tempPath);//
	        if(!filePath.exists()) {
	        	filePath.mkdirs();
	        }  	        	        	              
	        return tempPath;
	    }
		private static String AddZero(int time)
	    {
	        int a = time;        
	        return a > 9 ? String.valueOf(a) : "0" + a;
	    }

	}
	
	private static class VehicleDetectRunnable implements Runnable {
		private BufferedImage globalBufferedImage;
		private BufferedImage vehicleBufferedImage;
		private NET_SDK_IVE_VEHICE_ITEM_INFO vehiclerecognitionInfo;
		
	    
		public VehicleDetectRunnable(BufferedImage globalBufferedImage,
						  		       BufferedImage vehicleBufferedImage,
						  		     NET_SDK_IVE_VEHICE_ITEM_INFO vehiclerecognitionInfo) {

			this.globalBufferedImage = globalBufferedImage;
			this.vehicleBufferedImage = vehicleBufferedImage;
			this.vehiclerecognitionInfo = vehiclerecognitionInfo;		
		}
		@Override
		public void run() {
			if(!isAttach) {
             	return;
            }	        
	        // 列表显示事件信息 
		    showVehicleRecognitionEventInfo(globalBufferedImage, 
		    		vehicleBufferedImage, 
		    		vehiclerecognitionInfo); 
		}
	}
	private static void showVehicleRecognitionEventInfo(BufferedImage globalBufferedImage,
	          BufferedImage vehicleBufferedImage,
	          NET_SDK_IVE_VEHICE_ITEM_INFO vehiclerecognitionInfo) {
		globalPicLabel.setText(Res.string().getGlobalPicture() + " ------ [车牌识别]");
		
		// 全景图
		if(globalBufferedImage != null) {
		globalPicShowPanel.setImage(globalBufferedImage);
		globalPicShowPanel.setOpaque(false); 
		globalPicShowPanel.repaint();
		} else {
		globalPicShowPanel.setOpaque(true); 
		globalPicShowPanel.repaint();
		}
		
		// 车牌图
		if(vehicleBufferedImage != null) {
			vehiclePicShowPanel.setImage(vehicleBufferedImage);
			vehiclePicShowPanel.setOpaque(false); 
			vehiclePicShowPanel.repaint();
		} else {
			vehiclePicShowPanel.setOpaque(true); 
			vehiclePicShowPanel.repaint();
		}
	
		if(vehiclerecognitionInfo.plate != null) {			
			plateField.setText(CommonFunctions.ByteToStr(vehiclerecognitionInfo.plate,"UTF8") + " 方向:" + vehiclerecognitionInfo.iVehicleDirect);
			//lDirect.setText(vehiclerecognitionInfo.iVehicleDirect.);
			
		}	
	}

}

public class VehicleRecognize {
	//private static JButton btnNewButton;

	public static void main(String[] args) {	
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				VehicleRecognizeFrame demo = new VehicleRecognizeFrame();	
				demo.setTitle(Res.string().getVehicleRecognition());
				
				demo.setVisible(true);
			}
		});		
	}
}
